import java.rmi.server.*;
import java.rmi.*;

public class Connection_controller extends UnicastRemoteObject implements Connection_controller_interface
{
	private Server server;
	private File_handler fh;
	
	/**
	 * Constructor
	 **/
	
	public Connection_controller(Server server) throws RemoteException
	{
		this.server = server;
		fh = new File_handler();
	}
	
	/**
	 * For starting a game
	 * @param numberOfPlayers - How many players are playing this game
	 * @param playerNicks - Nicknames for all players
	 * @param playerPW - PassWords for all players
	 **/
	
	public void startGame(int numberOfPlayers, String [] playerNicks, String [] playerPW) throws RemoteException
	{
		fh.startGame(0, numberOfPlayers, playerNicks, playerPW);
	}
	
	/**
	 * NOT FINISHED - Not sure if this should only be temp or not
	 * At present time it only loads the game to show if it works
	 **/
	
	public void loadGame(int gameNumber) throws RemoteException
	{
		fh.loadGame(gameNumber);
	}
	
	/**
	 * When a player needs to login
	 * @param gameNumber - What game is this player playing
	 * @param playerNick - Nickname of player
	 * @param playerPW - PassWord for player
	 * @return Player index, used on Server (-1 if login failed)
	 **/
	
	public int login(int gameNumber, String playerNick, String playerPW) throws RemoteException
	{		
		return fh.login(gameNumber, playerNick, playerPW);
	}
}